﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using DevExpress.Xpf.Grid;
using DevExpress.Xpf.Bars;
using DevExpress.Xpf.Grid.TreeList;
using System.Collections.ObjectModel;
using System.Windows.Interactivity;
using System.Collections;

namespace WpfApplication15
{
    /// <summary>
    /// Interaction logic for Window1.xaml
    /// </summary>
    public partial class Window1 : Window
    {
        ObservableCollection<DataItem> dataList;
        public Window1()
        {
            InitializeComponent();
            dataList = new ObservableCollection<DataItem>();
            for (int i = 0; i < 10; i++)
            {
                TreeListNode node = new TreeListNode(new DataItem()
                                                         {
                                                             ID = i,
                                                             Value = i * 10,
                                                             Text = "Item#" + i.ToString(),
                                                             Details = "Item#" + i.ToString() + ": Details",
                                                             Listo =
                                                                 new List<string>() { i + "", i + "", i + "", i + "", i + "" },
                                                             Type = "Test Type 1"
                                                         });
                for (int j = 0; j < 5; j++)
                {
                    TreeListNode child_node = new TreeListNode(new DataItem1()
                    {
                        ID = j,
                        Value = j * 10,
                        Text = "Item#" + j.ToString(),
                        Details = "Item#" + j.ToString() + ": Details",
                        Type = "Test Type 1"
                    });
                    node.Nodes.Add(child_node);
                }
                view1.Nodes.Add(node);
            }
            //gridControl1.ItemsSource = dataList;
            beh.AddRow = AddNodeDelegate;
            beh.ValidateNewRow = ValidateNewRow;

        }
        object AddNodeDelegate(object parentNode) {
            DataItem r = new DataItem();
            view1.ExpandNode(view1.FocusedNode.RowHandle);
            view1.FocusedNode.Nodes.Add(new TreeListNode(r));
            return r;
        }
        bool ValidateNewRow(object row) {
            if(((DataItem)row).ID == 0) return false;
            return true;
        }
        private void TreeListView_InvalidNodeException(object sender, DevExpress.Xpf.Grid.TreeList.TreeListInvalidNodeExceptionEventArgs e)
        {
            //e.ExceptionMode = ExceptionMode.NoAction;
            //e.Handled = true;
        }

        private void TreeListView_ValidateNode(object sender, DevExpress.Xpf.Grid.TreeList.TreeListNodeValidationEventArgs e)
        {
            //e.SetError("error");
            
            //e.IsValid = false;
            //e.Handled = true;
        }

        private void TreeListView_ValidateCell(object sender, DevExpress.Xpf.Grid.TreeList.TreeListCellValidationEventArgs e) {
            //if (e.Value != null && Int32.Parse(e.Value.ToString()) > 10)
            //{
            //    Console.WriteLine((e.Node.Content as DataItem).Listo);
            //    e.SetError("error message");
            //    e.IsValid = false;
            //    e.Handled = true;
            //}
        }

        private void BarButtonItem_ItemClick(object sender, DevExpress.Xpf.Bars.ItemClickEventArgs e) {
            //BarButtonItem item = (BarButtonItem)sender;
            //GridCellMenuInfo info = (GridCellMenuInfo)item.DataContext;
            //TreeListRowData rowData = (TreeListRowData)info.Row;
            //dataList.Add(new DataItem());
            //((DataItem)rowData.Row).Listo.Add()
            //item.DataContext
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            view1.BestFitColumns();
        }

        private void view1_NodeExpanding(object sender, TreeListNodeAllowEventArgs e)
        {
            for (int i = 0; i < 3; i++)
            {
                TreeListNode node = new TreeListNode(new DataItem()
                                                         {
                                                             ID = i,
                                                             Value = i*10,
                                                             Text = "dummy#" + i.ToString(),
                                                             Details = "Item#" + i.ToString() + ": Details",
                                                             Listo =
                                                                 new List<string>()
                                                                     {i + "", i + "", i + "", i + "", i + ""},
                                                             Type = "Test Type 1"
                                                         });
                e.Node.Nodes.Add(node);
            }
        }


        private void CommandBinding_CanExecute(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        private void CommandBinding_Executed(object sender, ExecutedRoutedEventArgs e)
        {
            MessageBox.Show("Executed!");
        }
    }

    public class DataItem
    {
        public DataItem()
        {
            Types = new List<MyType>();
            Types.Add(new MyType(){ID=1, Name = "test type 1"});
            Types.Add(new MyType() { ID = 2, Name = "Test Type 2" });
            Types.Add(new MyType() { ID = 3, Name = "Test Type 3" });
        }
        public int ID { get; set; }
        public string Text { get; set; }
        public int Value { get; set; }
        public string Details { get; set; }
        public string Type { get; set; }
        public List<string> Listo { get; set; }
        public List<MyType> Types { get; set; }
    }

    public class MyType
    {
        public int ID { get; set; }
        public string Name { get; set; }
    }

    public class DataItem1
    {
        public int ID { get; set; }
        public string Text { get; set; }
        public int Value { get; set; }
        public string Details { get; set; }
        public string Type { get; set; }
    }
    public delegate object AddNodeDelegate(object parentNode);
    public delegate bool ValidateNewRow(object row);
    public class TreeListNewItemRowBehavior : Behavior<TreeListView> {
        public TreeListView View { get { return AssociatedObject; } }
        public bool IsNewRowAdding { get; private set; }
        public object NewRow { get; private set; }
        BarButtonItem Item;
        public AddNodeDelegate AddRow { get; set; }
        public ValidateNewRow ValidateNewRow { get; set; }
        public TreeListNewItemRowBehavior() {
            Item = new BarButtonItem() { Content = "Add Node" };
            Item.ItemClick += new ItemClickEventHandler(Item_ItemClick);
        }
        void Item_ItemClick(object sender, ItemClickEventArgs e) {
            BarButtonItem item = (BarButtonItem)sender;
            GridCellMenuInfo info = (GridCellMenuInfo)item.DataContext;
            TreeListRowData rowData = (TreeListRowData)info.Row;
            NewRow = AddRow(rowData.Row);
            if(NewRow == null) return;
            Start();
        }
        void Start() {
            IsNewRowAdding = true;
            Item.IsEnabled = false;
            Item.IsVisible = false;
            View.FocusedRow = NewRow;
            View.FocusedColumn = ((GridControl)View.DataControl).Columns[0];
            View.Focus();
            View.ShowEditor();
            //object o = View.ActiveEditor.EditValue;
            //View.ActiveEditor.EditValue = "c";
            //View.ActiveEditor.EditValue = o;
        }
        void Complete() {
            IsNewRowAdding = false;
            Item.IsEnabled = true;
            Item.IsVisible = true;
            NewRow = null;
        }
        void Cancel() {
            IsNewRowAdding = false;
            Item.IsEnabled = true;
            Item.IsVisible = true;
            ((IList)View.DataControl.ItemsSource).Remove(NewRow);
        }
        bool ValidateCore() {
            if(ValidateNewRow(NewRow)) {
                Complete();
                return true;
            } else {
                MessageBoxResult r = MessageBox.Show("Do you want to continue?", "New Row is incorrect", MessageBoxButton.OKCancel);
                if(r == MessageBoxResult.OK) {
                    Cancel();
                    return true;
                } else {
                    Dispatcher.BeginInvoke(new Action(() => {
                        View.FocusedRow = NewRow;
                        View.FocusedColumn = ((GridControl)View.DataControl).Columns[0];
                        View.Focus();
                        View.ShowEditor();
                    }), System.Windows.Threading.DispatcherPriority.Render, new object[] { });
                    return false;
                }
            }
        }
        void View_FocusedRowChanged(object sender, FocusedRowChangedEventArgs e) {
            if(e.NewRow == NewRow) return;
            if(IsNewRowAdding) {
                ValidateCore();
            }
        }
        void View_PreviewKeyDown(object sender, KeyEventArgs e) {
            if(IsNewRowAdding && e.Key == Key.Escape) {
                Cancel();
                e.Handled = true;
            }
        }
        void View_ValidateNode(object sender, TreeListNodeValidationEventArgs e) {
            if(IsNewRowAdding) {
                e.IsValid = ValidateCore();
                e.Handled = true;
            }
        }
        void View_InvalidNodeException(object sender, TreeListInvalidNodeExceptionEventArgs e) {
            if(IsNewRowAdding) {
                e.ExceptionMode = ExceptionMode.NoAction;
                e.Handled = true;
            }
        }
        protected override void OnAttached() {
            base.OnAttached();
            View.RowCellMenuCustomizations.Add(Item);
            View.FocusedRowChanged += new FocusedRowChangedEventHandler(View_FocusedRowChanged);
            View.PreviewKeyDown += new KeyEventHandler(View_PreviewKeyDown);
            View.ValidateNode += new TreeListNodeValidationEventHandler(View_ValidateNode);
            View.InvalidNodeException += new TreeListInvalidNodeExceptionEventHandler(View_InvalidNodeException);
        }
        protected override void OnDetaching() {
            View.InvalidNodeException -= new TreeListInvalidNodeExceptionEventHandler(View_InvalidNodeException);
            View.ValidateNode -= new TreeListNodeValidationEventHandler(View_ValidateNode);
            View.PreviewKeyDown -= new KeyEventHandler(View_PreviewKeyDown);
            View.FocusedRowChanged -= new FocusedRowChangedEventHandler(View_FocusedRowChanged);
            View.RowCellMenuCustomizations.Remove(Item);
            base.OnDetaching();
        }
    }
}
