﻿// Developer Express Code Central Example:
// How to print group summary values under corresponding columns
// 
// This example is the addition to the http://www.devexpress.com/scid=A1041
// knowledge base article, demonstrating how to print the GridView in the same
// manner.
// 
// You can find sample updates and versions for different programming languages here:
// http://www.devexpress.com/example=E2084
using System;
using System.Windows.Forms;
using System.Diagnostics;

namespace Q250602 {
    public partial class Form1 : Form {
        public Form1() {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e) {
            // TODO: This line of code loads data into the 'nwindDataSet.Order_Details' table. You can move, or remove it, as needed.
            this.order_DetailsTableAdapter.Fill(this.nwindDataSet.Order_Details);
        }

        private void OnShowPrintPreviewButtonClick(object sender, EventArgs e) {
            orderDetailsGrid.ShowPrintPreview();
        }

        private void OnExportToXlsButtonClick(object sender, EventArgs e) {
            const string filePath = @"..\..\order_details.xls";
            orderDetailsGrid.ExportToXls(filePath);
            Process.Start(filePath);
        }

        private void simpleButton3_Click(object sender, EventArgs e) {
            const string filePath = @"..\..\order_details.xls";
            printableComponentLink1.CreateReportHeaderArea += new DevExpress.XtraPrinting.CreateAreaEventHandler(printableComponentLink1_CreateReportHeaderArea);
            printableComponentLink1.CreateDocument();
            printingSystem1.ExportToXls(filePath);
            Process.Start(filePath);
        }

        private void printableComponentLink1_CreateReportHeaderArea(object sender, DevExpress.XtraPrinting.CreateAreaEventArgs e) {
            e.Graph.DrawString("Text", new System.Drawing.RectangleF(0, 0, 100, 30));
        }
    }
}
